<?php

/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://text.lk
 * @since      1.0.0
 *
 * @package    TextLK
 * @subpackage TextLK/admin/partials
 */

// If this file is called directly, abort.
if (!defined('WPINC')) {
    die;
}
?>

<!-- This file should primarily consist of HTML with a little bit of PHP. -->
<div class="wrap">
    <?php include('textlk_admin_header.php'); ?>
    <div class="textlk-admin-layout-content">

        <?php include('textlk_admin_content_floating_brand.php'); ?>

        <h2>
            <span class="dashicons dashicons-format-status"></span> <?php esc_attr_e('SMS Campaign', 'textlk-wp'); ?>
        </h2>

        <?php
        //Grab all options
        $options = get_option($this->plugin_name);

        $balance = '';

        if (!$options || empty($options['textlk_sms_api_key'])) {
            $balance = 'Please configure SMS API first.';
        } else {
            require_once TEXTLK_WP_PATH. 'includes/sms.class.php';

            $smsPortal = new TextLK_SMS($options['textlk_sms_api_key']);

            $response = $smsPortal->getBalance(); 

            if ($response && $response->error === 0) {
                $balance = str_replace('Rs ', '', $response->data->balance);
            } elseif ($response && $response->error === 405) {
                $balance = 'Please configure SMS API first.';
            } else {
                $balance = 'Unknown Error, failed to fetch balance';
            }
        }
        ?>

        <?php if (is_numeric($balance)): ?>
            <p><strong>Balance:</strong> <?php echo esc_html( number_format((float)$balance, 2, '.', ',') ) ?> </p>
        <?php else: ?>
            <p><strong>Balance:</strong> <strong class='text-danger'><?php echo esc_html( $balance ) ?></strong>
        <?php endif; ?>

        <!--   show notice when form submit -->
        <?php settings_errors(); ?>

        <form method="post" name=" <?php echo esc_attr( $this->plugin_name ); ?>"
            action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>">
            <input type="hidden" name="action" value="<?php echo esc_attr( $this->plugin_name . '_campaign' ) ?>">

            <!-- Phone Numbers -->
            <fieldset class="mb-2">
                <p class="mb-2"><strong><?php esc_attr_e('Enter Phone Numbers', 'textlk-wp'); ?></strong></p>
                <legend class="screen-reader-text">
                    <span><?php esc_attr_e( 'Enter Phone Numbers', 'textlk-wp' ); ?></span>
                </legend>
                <textarea
                        class="d-block"
                        id="<?php echo esc_attr( $this->plugin_name . '-numbers' ); ?>"
                        name="<?php echo esc_attr( $this->plugin_name . '[numbers]' ); ?>"
                        rows="2"
                        cols="70"></textarea>
                <small>New Line Separated</small>
            </fieldset>

            <!-- Checkbox -->
            <fieldset>
                <legend class="screen-reader-text">
                    <span><?php esc_attr_e('Include all customers', 'textlk-wp'); ?></span>
                </legend>
                <label for="<?php echo esc_attr( $this->plugin_name . '-all_users' ); ?>">
                    <input type="checkbox" id="<?php echo esc_attr( $this->plugin_name . '-all_users' ); ?>"
                        name="<?php echo esc_attr( $this->plugin_name . '[all_users]' ); ?>" value="1"/>
                    <span><?php esc_attr_e( 'Include all customers', 'textlk-wp' ); ?></span>
                </label>
            </fieldset>

            <!-- SMS Body -->
            <fieldset>
                <p class="mb-2"><strong><?php esc_attr_e( 'Enter SMS Content', 'textlk-wp' ); ?></strong></p>
                <legend class="screen-reader-text">
                    <span><?php esc_attr_e( 'Enter SMS Content', 'textlk-wp' ); ?></span>
                </legend>
                <textarea
                        class="d-block"
                        id="<?php echo esc_attr( $this->plugin_name . '-body' ); ?>"
                        name="<?php echo esc_attr( $this->plugin_name . '[body]' ); ?>"
                        rows="8"
                        cols="70"
                        required></textarea>
            </fieldset>


            <?php submit_button(__('Send SMS', 'textlk-wp'), 'primary', 'submit', true); ?>
        </form>
    </div>
</div>