<?php

/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://text.lk
 * @since      1.0.0
 *
 * @package    TextLK
 * @subpackage TextLK/admin/partials
 */

// If this file is called directly, abort.
if (!defined('WPINC')) {
    die;
}

$has_woocommerce = is_plugin_active('woocommerce/woocommerce.php');
?>

<!-- This file should primarily consist of HTML with a little bit of PHP. -->
<div class="wrap">
    <?php include('textlk_admin_header.php'); ?>
    <div class="textlk-admin-layout-content">

        <?php include('textlk_admin_content_floating_brand.php'); ?>

        <h2><span class="dashicons dashicons-admin-tools"></span> 
            Text.lk
            <?php esc_attr_e('Options', 'textlk-wp'); ?></h2>
        <p>Here you can set all the options for using the API</p>

        <!--   show admin notice when settings are saved-->
        <?php settings_errors(); ?>

        <form method="post" name="<?php echo esc_attr($this->plugin_name); ?>" action="options.php" id="<?php echo esc_attr($this->plugin_name); ?>">
            <?php
            $order_alerts =
                [
                    "DEFAULT_ORDER_STATUS_PENDING_SMS" => __(
                        "[store_name] - Payment required for Order #[order_id]\nYour order #[order_id] at [store_name] is currently pending payment. Please complete payment as soon as possible.",
                        "textlk-wp"
                    ),
                    "DEFAULT_ORDER_STATUS_PROCESSING_SMS" => __(
                        "[store_name] - Order #[order_id] is being processed\nYour order #[order_id] at [store_name] is currently being processed.",
                        "textlk-wp"
                    ),
                    "DEFAULT_ORDER_STATUS_ON_HOLD_SMS" => __(
                        "[store_name] - Order #[order_id] is on hold\nYour order #[order_id] at [store_name] is currently on hold. Our customer service team will be reaching out to you shortly.",
                        "textlk-wp"
                    ),
                    "DEFAULT_ORDER_STATUS_COMPLETED_SMS" => __(
                        "[store_name] - Order #[order_id] has been completed\nYour order #[order_id] at [store_name] has been completed and is on its way to you.",
                        "textlk-wp"
                    ),
                    "DEFAULT_ORDER_STATUS_CANCELLED_SMS" => __(
                        "[store_name] - Order #[order_id] has been cancelled\nYour order #[order_id] at [store_name] has been cancelled. Please contact our customer service team for any questions or concerns.",
                        "textlk-wp"
                    ),
                    "DEFAULT_ORDER_STATUS_REFUNDED_SMS" => __(
                        "[store_name] - Order #[order_id] has been refunded\nYour order #[order_id] at [store_name] has been refunded. Please contact our customer service team for any questions or concerns.",
                        "textlk-wp"
                    ),
                    "DEFAULT_ORDER_STATUS_FAILED_SMS" => __(
                        "[store_name] - Order #[order_id] has failed\nYour order #[order_id] at [store_name] has failed. Please contact our customer service team for any questions or concerns.",
                        "textlk-wp"
                    ),
                    "DEFAULT_ADMIN_STATUS_SMS" => __(
                        "[store_name] - A new order #[order_id] for value [order_currency] [order_amount] has just been placed. Please check your admin dashboard for complete details.",
                        "textlk-wp"
                    ),

                    "DEFAULT_ORDER_STATUS_RECEIPT_APPROVAL_SMS" => __(
                        "[store_name] - Order #[order_id] has been receipt approval\nYour order #[order_id] at [store_name] has been receipt approval and is on its way to you.",
                        "textlk-wp"
                    ),
                    "DEFAULT_ORDER_STATUS_RECEIPT_UPLOAD_SMS" => __(
                        "[store_name] - Order #[order_id] has been receipt upload\nYour order #[order_id] at [store_name] has been receipt upload. Please contact our customer service team for any questions or concerns.",
                        "textlk-wp"
                    ),
                    "DEFAULT_ORDER_STATUS_SHIPPED_SMS" => __(
                        "[store_name] - Order #[order_id] has been shipped\nYour order #[order_id] at [store_name] has been shipped. Please contact our customer service team for any questions or concerns.",
                        "textlk-wp"
                    ),
                    "DEFAULT_ORDER_STATUS_PACKED_SMS" => __(
                        "[store_name] - Order #[order_id] has been packed\nYour order #[order_id] at [store_name] has packed. Please contact our customer service team for any questions or concerns.",
                        "textlk-wp"
                    ),

                ];

            //Grab all options
            $options = get_option($this->plugin_name);

            $textlk_sms_api_key = (isset($options['textlk_sms_api_key']) && !empty($options['textlk_sms_api_key'])) ? $options['textlk_sms_api_key'] : '';

            if (strlen($textlk_sms_api_key) === 40) {
                $textlk_sms_api_key = substr_replace(esc_attr($options['textlk_sms_api_key']), str_repeat('*', 24), 12, 16);
            }

            $sender_id = (isset($options['sender_id']) && !empty($options['sender_id'])) ? esc_attr($options['sender_id']) : '';

            $wp_reg = (isset($options['wp_reg']) && !empty($options['wp_reg'])) ? 1 : 0;
            $wp_login = (isset($options['wp_login']) && !empty($options['wp_login'])) ? 1 : 0;
            $wc_reg = (isset($options['wc_reg']) && !empty($options['wc_reg'])) ? 1 : 0;
            $wc_login = (isset($options['wc_login']) && !empty($options['wc_login'])) ? 1 : 0;
            $otp_checkout = (isset($options['otp_checkout']) && !empty($options['otp_checkout'])) ? 1 : 0;
            $admin_phones = (isset($options['admin_phones']) && !empty($options['admin_phones'])) ? esc_attr($options['admin_phones']) : '';


            $order_status_pending             = (isset($options['order_status_pending']) && !empty($options['order_status_pending'])) ? 1 : 0;
            $order_status_pending_sms         = (isset($options['ORDER_STATUS_PENDING_SMS']) && !empty($options['ORDER_STATUS_PENDING_SMS'])) ? $options['ORDER_STATUS_PENDING_SMS'] : $order_alerts['DEFAULT_ORDER_STATUS_PENDING_SMS'];
            $order_status_processing          = (isset($options['order_status_processing']) && !empty($options['order_status_processing'])) ? 1 : 0;
            $order_status_processing_sms      = (isset($options['ORDER_STATUS_PROCESSING_SMS']) && !empty($options['ORDER_STATUS_PROCESSING_SMS'])) ? $options['ORDER_STATUS_PROCESSING_SMS'] : $order_alerts['DEFAULT_ORDER_STATUS_PROCESSING_SMS'];
            $order_status_on_hold             = (isset($options['order_status_on_hold']) && !empty($options['order_status_on_hold'])) ? 1 : 0;
            $order_status_on_hold_sms         = (isset($options['ORDER_STATUS_ON_HOLD_SMS']) && !empty($options['ORDER_STATUS_ON_HOLD_SMS'])) ? $options['ORDER_STATUS_ON_HOLD_SMS'] : $order_alerts['DEFAULT_ORDER_STATUS_ON_HOLD_SMS'];
            $order_status_completed           = (isset($options['order_status_completed']) && !empty($options['order_status_completed'])) ? 1 : 0;
            $order_status_completed_sms       = (isset($options['ORDER_STATUS_COMPLETED_SMS']) && !empty($options['ORDER_STATUS_COMPLETED_SMS'])) ? $options['ORDER_STATUS_COMPLETED_SMS'] : $order_alerts['DEFAULT_ORDER_STATUS_COMPLETED_SMS'];
            $order_status_cancelled           = (isset($options['order_status_cancelled']) && !empty($options['order_status_cancelled'])) ? 1 : 0;
            $order_status_cancelled_sms       = (isset($options['ORDER_STATUS_CANCELLED_SMS']) && !empty($options['ORDER_STATUS_CANCELLED_SMS'])) ? $options['ORDER_STATUS_CANCELLED_SMS'] : $order_alerts['DEFAULT_ORDER_STATUS_CANCELLED_SMS'];
            $order_status_refunded            = (isset($options['order_status_refunded']) && !empty($options['order_status_refunded'])) ? 1 : 0;
            $order_status_refunded_sms        = (isset($options['ORDER_STATUS_REFUNDED_SMS']) && !empty($options['ORDER_STATUS_REFUNDED_SMS'])) ? $options['ORDER_STATUS_REFUNDED_SMS'] : $order_alerts['DEFAULT_ORDER_STATUS_REFUNDED_SMS'];
            $order_status_failed              = (isset($options['order_status_failed']) && !empty($options['order_status_failed'])) ? 1 : 0;
            $order_status_failed_sms          = (isset($options['ORDER_STATUS_FAILED_SMS']) && !empty($options['ORDER_STATUS_FAILED_SMS'])) ? $options['ORDER_STATUS_FAILED_SMS'] : $order_alerts['DEFAULT_ORDER_STATUS_FAILED_SMS'];
            $order_status_admin               = (isset($options['order_status_admin']) && !empty($options['order_status_admin'])) ? 1 : 0;
            $admin_status_sms                 = (isset($options['ADMIN_STATUS_SMS']) && !empty($options['ADMIN_STATUS_SMS'])) ? $options['ADMIN_STATUS_SMS'] : $order_alerts['DEFAULT_ADMIN_STATUS_SMS'];

            $order_status_receipt_approval      = (isset($options['order_status_receipt_approval']) && !empty($options['order_status_receipt_approval'])) ? 1 : 0;
            $order_status_receipt_approval_sms  = (isset($options['ORDER_STATUS_RECEIPT_APPROVAL_SMS']) && !empty($options['ORDER_STATUS_RECEIPT_APPROVAL_SMS'])) ? $options['ORDER_STATUS_RECEIPT_APPROVAL_SMS'] : $order_alerts['DEFAULT_ORDER_STATUS_RECEIPT_APPROVAL_SMS'];
            $order_status_receipt_upload        = (isset($options['order_status_receipt_upload']) && !empty($options['order_status_receipt_upload'])) ? 1 : 0;
            $order_status_receipt_upload_sms    = (isset($options['ORDER_STATUS_RECEIPT_UPLOAD_SMS']) && !empty($options['ORDER_STATUS_RECEIPT_UPLOAD_SMS'])) ? $options['ORDER_STATUS_RECEIPT_UPLOAD_SMS'] : $order_alerts['DEFAULT_ORDER_STATUS_RECEIPT_UPLOAD_SMS'];
            $order_status_shipped               = (isset($options['order_status_shipped']) && !empty($options['order_status_shipped'])) ? 1 : 0;
            $order_status_shipped_sms           = (isset($options['ORDER_STATUS_SHIPPED_SMS']) && !empty($options['ORDER_STATUS_SHIPPED_SMS'])) ? $options['ORDER_STATUS_SHIPPED_SMS'] : $order_alerts['DEFAULT_ORDER_STATUS_SHIPPED_SMS'];
            $order_status_packed                = (isset($options['order_status_packed']) && !empty($options['order_status_packed'])) ? 1 : 0;
            $order_status_packed_sms            = (isset($options['ORDER_STATUS_PACKED_SMS']) && !empty($options['ORDER_STATUS_PACKED_SMS'])) ? $options['ORDER_STATUS_PACKED_SMS'] : $order_alerts['DEFAULT_ORDER_STATUS_PACKED_SMS'];

            if (!empty($textlk_sms_api_key)) {

                require_once TEXTLK_WP_PATH . 'includes/sms.class.php';

                $smsPortal = new TextLK_SMS($options['textlk_sms_api_key']);

                $response = $smsPortal->getBalance();

                if ($response && $response->error === 0) {
                    $balance = str_replace('Rs ', '', $response->data->balance);
                } elseif ($response && $response->error === 405) {
                    $balance = 'Authentication Failed. Please enter a valid API Key.';
                } else {
                    $balance = 'Unknown Error, failed to fetch balance.';
                }
            } else {
                $balance = "empty";
            }

            settings_fields($this->plugin_name);
            do_settings_sections($this->plugin_name);
            ?>

            <!-- API Key -->
            <table class="form-table" aria-label="admin settings form">
                <tr>
                    <th scope="row">
                        <label for="<?php echo esc_attr($this->plugin_name . '-textlk_sms_api_key'); ?>">
                            <?php esc_attr_e('API Key*', 'textlk-wp'); ?>
                        </label>
                        <br>
                        <a href="https://app.text.lk/developers" target="_blank" rel="noopener noreferrer">
                            <small><?php esc_attr_e('Get Your API Key', 'textlk-wp'); ?></small>
                        </a>
                    </th>
                    <td>
                        <input id="<?php echo esc_attr($this->plugin_name . '-textlk_sms_api_key'); ?>" name="<?php echo esc_attr($this->plugin_name . '[textlk_sms_api_key]'); ?>" type="text" size="55" placeholder="Enter API Key" value="<?php if (!empty($textlk_sms_api_key)) {
                                                                                                                                                                                                                                echo esc_attr($textlk_sms_api_key);
                                                                                                                                                                                     } ?>" />
                    </td>
                </tr>

                <tr>
                    <th scope="row">
                        <label for="<?php echo esc_attr($this->plugin_name . '-sender_id'); ?>">
                            <?php esc_attr_e('Sender ID*', 'textlk-wp'); ?>
                        </label>
                        <br>
                        <a href="https://app.text.lk/senderid" target="_blank" rel="noopener noreferrer">
                            <small><?php esc_attr_e('Get Your Sender ID', 'textlk-wp'); ?></small>
                        </a>
                    </th>
                    <td>
                        <input id="<?php echo esc_attr($this->plugin_name . '-sender_id'); ?>" name="<?php echo esc_attr($this->plugin_name . '[sender_id]'); ?>" type="text" size="55" value="<?php echo esc_attr($sender_id); ?>" />
                    </td>
                </tr>

                <tr>
                    <th scope="row">
                        <label for="<?php echo esc_attr($this->plugin_name . '-balance'); ?>"></label>
                    </th>
                    <td>
                        <span id="<?php echo esc_attr($this->plugin_name . '-balance'); ?>">
                            <?php if ($balance === 'empty') : ?>
                                <strong>Don't have an account? <a href='https://app.text.lk/register/'>Register Now</a> (Free
                                    SMS Credit after Sign-up).</strong>
                            <?php elseif (is_numeric($balance)) : ?>
                                <strong>Balance:</strong>
                                <?php echo esc_html(number_format((float)$balance, 2, '.', ',')) ?>
                            <?php else : ?>
                                <strong>Balance:</strong>
                                <strong class="text-danger"><?php echo esc_html($balance); ?></strong>
                            <?php endif; ?>
                        </span>
                    </td>
                </tr>
            </table>

            <hr>

            <h3><?php esc_attr_e('WordPress', 'textlk-wp'); ?></h3>
            <ol class="switches">
                <li>
                    <input type="checkbox" id="<?php echo esc_attr($this->plugin_name . '-wp_reg'); ?>" name="<?php echo esc_attr($this->plugin_name . '[wp_reg]'); ?>" <?php checked($wp_reg, 1); ?> />
                    <label for="<?php echo esc_attr($this->plugin_name . '-wp_reg'); ?>">
                        <span class="toggle_btn"></span>
                        <span><?php esc_attr_e('Two Factor OTP Verification For WordPress Register Form', 'textlk-wp'); ?></span>
                    </label>
                </li>

                <li>
                    <input type="checkbox" id="<?php echo esc_attr($this->plugin_name . '-wp_login'); ?>" name="<?php echo esc_attr($this->plugin_name . '[wp_login]'); ?>" <?php checked($wp_login, 1); ?> />
                    <label for="<?php echo esc_attr($this->plugin_name . '-wp_login'); ?>">
                        <span class="toggle_btn"></span>
                        <span><?php esc_attr_e('Two Factor OTP Verification For WordPress Login Form', 'textlk-wp'); ?></span>
                    </label>
                </li>

            </ol>

          	<br><hr>
          
          	<h3><?php esc_attr_e('Woocommerce', 'textlk-wp'); ?></h3>

            <?php
            if ($has_woocommerce) { ?>

                <ol class="switches">
                    <li>
                        <input type="checkbox" id="<?php echo esc_attr($this->plugin_name . '-wc_reg'); ?>" name="<?php echo esc_attr($this->plugin_name . '[wc_reg]'); ?>" <?php checked($wc_reg, 1); ?> />
                        <label for="<?php echo esc_attr($this->plugin_name . '-wc_reg'); ?>">
                            <span class="toggle_btn"></span>
                            <span><?php esc_attr_e('Two Factor OTP Verification For Woocommerce Register Form', 'textlk-wp'); ?></span>
                        </label>
                    </li>

                    <li>
                        <input type="checkbox" id="<?php echo esc_attr($this->plugin_name . '-wc_login'); ?>" name="<?php echo esc_attr($this->plugin_name . '[wc_login]'); ?>" <?php checked($wc_login, 1); ?> />
                        <label for="<?php echo esc_attr($this->plugin_name . '-wc_login'); ?>">
                            <span class="toggle_btn"></span>
                            <span><?php esc_attr_e('Two Factor OTP Verification For Woocommerce Login Form', 'textlk-wp'); ?></span>
                        </label>
                    </li>

                    <li>
                        <input type="checkbox" id="<?php echo esc_attr($this->plugin_name . '-otp_checkout'); ?>" name="<?php echo esc_attr($this->plugin_name . '[otp_checkout]'); ?>" <?php checked($otp_checkout, 1); ?> />
                        <label for="<?php echo esc_attr($this->plugin_name . '-otp_checkout'); ?>">
                            <span class="toggle_btn"></span>
                            <span><?php esc_attr_e('OTP Verification For Guest Customer Checkout', 'textlk-wp'); ?></span>
                        </label>
                    </li>

                    <li>
                        <input class="textlk-collapse" type="checkbox" id="<?php echo esc_attr($this->plugin_name . '-order_status_admin'); ?>" name="<?php echo esc_attr($this->plugin_name . '[order_status_admin]'); ?>" <?php checked(
                                                                                                                                                                                                                                    $order_status_admin,
                                                                                                                                                                                                                                    1
                                                                                                                                                                                                                                ); ?> />
                        <label for="<?php echo esc_attr($this->plugin_name . '-order_status_admin'); ?>">
                            <span class="toggle_btn"></span>
                            <span><?php esc_attr_e('Notify Admin on New Order', 'textlk-wp'); ?></span>
                        </label>
                        <div class="textlk-collapsable" id="order_status_admin">
                            <fieldset class="notify_template">
                                <legend>
                                    <h4 class="mb-2">
                                        <label for="<?php echo esc_attr($this->plugin_name . '-admin_phones'); ?>">
                                            <?php esc_attr_e(
                                                'Admin Phone Numbers (comma separated)',
                                                'textlk-wp'
                                            ); ?>
                                        </label>
                                    </h4>
                                    <input id="<?php echo esc_attr($this->plugin_name . '-admin_phones'); ?>" name="<?php echo esc_attr($this->plugin_name . '[admin_phones]'); ?>" type="text" size="82" class="mb-2" value="<?php echo esc_attr($admin_phones); ?>" />
                                    <span class="my-2 d-block sms_tokens"><span>[store_name]</span> |
                                        <span>[billing_first_name]</span> |
                                        <span>[order_id]</span> |
                                        <span>[order_status]</span> |  <span>[order_date_created]</span> </span>
                                        <span>[order_currency]</span> | <span>[order_amount]</span>
                                    </span>
                                </legend>
                                <textarea id="<?php echo esc_attr($this->plugin_name . '-admin_status_sms'); ?>" name="<?php echo esc_attr($this->plugin_name . '[ADMIN_STATUS_SMS]'); ?>" rows="3" cols="85"><?php echo esc_html($admin_status_sms); ?></textarea>
                            </fieldset>

                        </div>
                    </li>


                    <!-- working start -->


                    <h3>Notify Customer</h3>


                    <li>
                        <input class="textlk-collapse" type="checkbox" id="<?php echo esc_attr($this->plugin_name . '-order_status_pending'); ?>" name="<?php echo esc_attr($this->plugin_name . '[order_status_pending]'); ?>" <?php checked($order_status_pending, 1); ?> />
                        <label for="<?php echo esc_attr($this->plugin_name . '-order_status_pending'); ?>">
                            <span class="toggle_btn"></span>
                            <span><?php esc_attr_e('On Order Pending', 'textlk-wp'); ?></span>
                        </label>
                        <div class="textlk-collapsable" id="order_status_pending">

                            <fieldset class="notify_template">
                                <legend>
                                    <span class="sms_tokens my-2 d-block"><span>[store_name]</span> |
                                        <span>[billing_first_name]</span> |
                                        <span>[order_id]</span> |
                                        <span>[order_status]</span> |  <span>[order_date_created]</span>
                                        <span>[order_currency]</span> | <span>[order_amount]</span>
                                    </span>
                                </legend>

                                <textarea id="<?php echo esc_attr($this->plugin_name . '-order_status_pending_sms'); ?>" name="<?php echo esc_attr($this->plugin_name . '[ORDER_STATUS_PENDING_SMS]'); ?>" rows="4" cols="85"><?php echo esc_html($order_status_pending_sms); ?></textarea>
                            </fieldset>

                        </div>
                    </li>


                    <li>
                        <input class="textlk-collapse" type="checkbox" id="<?php echo esc_attr($this->plugin_name . '-order_status_processing'); ?>" name="<?php echo esc_attr($this->plugin_name . '[order_status_processing]'); ?>" <?php checked($order_status_processing, 1); ?> />
                        <label for="<?php echo esc_attr($this->plugin_name . '-order_status_processing'); ?>">
                            <span class="toggle_btn"></span>
                            <span><?php esc_attr_e('On Order Processing', 'textlk-wp'); ?></span>
                        </label>
                        <div class="textlk-collapsable" id="order_status_processing">

                            <fieldset class="notify_template">
                                <legend>
                                    <span class="sms_tokens my-2 d-block"><span>[store_name]</span> |
                                        <span>[billing_first_name]</span> |
                                        <span>[order_id]</span> |
                                        <span>[order_status]</span> |  <span>[order_date_created]</span>
                                        <span>[order_currency]</span> | <span>[order_amount]</span>
                                    </span>
                                </legend>

                                <textarea id="<?php echo esc_attr($this->plugin_name . '-order_status_processing_sms'); ?>" name="<?php echo esc_attr($this->plugin_name . '[ORDER_STATUS_PROCESSING_SMS]'); ?>" rows="4" cols="85"><?php echo esc_html($order_status_processing_sms); ?></textarea>
                            </fieldset>

                        </div>
                    </li>

                    <li>
                        <input class="textlk-collapse" type="checkbox" id="<?php echo esc_attr($this->plugin_name . '-order_status_on_hold'); ?>" name="<?php echo esc_attr($this->plugin_name . '[order_status_on_hold]'); ?>" <?php checked($order_status_on_hold, 1); ?> />
                        <label for="<?php echo esc_attr($this->plugin_name . '-order_status_on_hold'); ?>">
                            <span class="toggle_btn"></span>
                            <span><?php esc_attr_e('On Order On hold', 'textlk-wp'); ?></span>
                        </label>
                        <div class="textlk-collapsable" id="order_status_on_hold">

                            <fieldset class="notify_template">
                                <legend>
                                    <span class="sms_tokens my-2 d-block"><span>[store_name]</span> |
                                        <span>[billing_first_name]</span> |
                                        <span>[order_id]</span> |
                                        <span>[order_status]</span> |  <span>[order_date_created]</span>
                                        <span>[order_currency]</span> | <span>[order_amount]</span>
                                    </span>
                                </legend>

                                <textarea id="<?php echo esc_attr($this->plugin_name . '-order_status_on_hold_sms'); ?>" name="<?php echo esc_attr($this->plugin_name . '[ORDER_STATUS_ON_HOLD_SMS]'); ?>" rows="4" cols="85"><?php echo esc_html($order_status_on_hold_sms); ?></textarea>
                            </fieldset>

                        </div>
                    </li>



                    <li>
                        <input class="textlk-collapse" type="checkbox" id="<?php echo esc_attr($this->plugin_name . '-order_status_completed'); ?>" name="<?php echo esc_attr($this->plugin_name . '[order_status_completed]'); ?>" <?php checked($order_status_completed, 1); ?> />
                        <label for="<?php echo esc_attr($this->plugin_name . '-order_status_completed'); ?>">
                            <span class="toggle_btn"></span>
                            <span><?php esc_attr_e('On Order Completed', 'textlk-wp'); ?></span>
                        </label>
                        <div class="textlk-collapsable" id="order_status_completed">

                            <fieldset class="notify_template">
                                <legend>
                                    <span class="sms_tokens my-2 d-block"><span>[store_name]</span> |
                                        <span>[billing_first_name]</span> |
                                        <span>[order_id]</span> |
                                        <span>[order_status]</span> |  <span>[order_date_created]</span> |  <span>[order_date_completed]</span> 
                                        <span>[order_currency]</span> | <span>[order_amount]</span>
                                    </span>
                                </legend>

                                <textarea id="<?php echo esc_attr($this->plugin_name . '-order_status_completed_sms'); ?>" name="<?php echo esc_attr($this->plugin_name . '[ORDER_STATUS_COMPLETED_SMS]'); ?>" rows="4" cols="85"><?php echo esc_html($order_status_completed_sms); ?></textarea>
                            </fieldset>

                        </div>
                    </li>


                    <li>
                        <input class="textlk-collapse" type="checkbox" id="<?php echo esc_attr($this->plugin_name . '-order_status_cancelled'); ?>" name="<?php echo esc_attr($this->plugin_name . '[order_status_cancelled]'); ?>" <?php checked($order_status_cancelled, 1); ?> />
                        <label for="<?php echo esc_attr($this->plugin_name . '-order_status_cancelled'); ?>">
                            <span class="toggle_btn"></span>
                            <span><?php esc_attr_e('On Order Cancelled', 'textlk-wp'); ?></span>
                        </label>
                        <div class="textlk-collapsable" id="order_status_cancelled">

                            <fieldset class="notify_template">
                                <legend>
                                    <span class="sms_tokens my-2 d-block"><span>[store_name]</span> |
                                        <span>[billing_first_name]</span> |
                                        <span>[order_id]</span> |
                                        <span>[order_status]</span> |  <span>[order_date_created]</span>
                                        <span>[order_currency]</span> | <span>[order_amount]</span>
                                    </span>
                                </legend>

                                <textarea id="<?php echo esc_attr($this->plugin_name . '-order_status_cancelled_sms'); ?>" name="<?php echo esc_attr($this->plugin_name . '[ORDER_STATUS_CANCELLED_SMS]'); ?>" rows="4" cols="85"><?php echo esc_html($order_status_cancelled_sms); ?></textarea>
                            </fieldset>

                        </div>
                    </li>


                    <li>
                        <input class="textlk-collapse" type="checkbox" id="<?php echo esc_attr($this->plugin_name . '-order_status_refunded'); ?>" name="<?php echo esc_attr($this->plugin_name . '[order_status_refunded]'); ?>" <?php checked($order_status_refunded, 1); ?> />
                        <label for="<?php echo esc_attr($this->plugin_name . '-order_status_refunded'); ?>">
                            <span class="toggle_btn"></span>
                            <span><?php esc_attr_e('On Order Refunded', 'textlk-wp'); ?></span>
                        </label>
                        <div class="textlk-collapsable" id="order_status_refunded">

                            <fieldset class="notify_template">
                                <legend>
                                    <span class="sms_tokens my-2 d-block"><span>[store_name]</span> |
                                        <span>[billing_first_name]</span> |
                                        <span>[order_id]</span> |
                                        <span>[order_status]</span> |  <span>[order_date_created]</span>
                                        <span>[order_currency]</span> | <span>[order_amount]</span>
                                    </span>
                                </legend>

                                <textarea id="<?php echo esc_attr($this->plugin_name . '-order_status_refunded_sms'); ?>" name="<?php echo esc_attr($this->plugin_name . '[ORDER_STATUS_REFUNDED_SMS]'); ?>" rows="4" cols="85"><?php echo esc_html($order_status_refunded_sms); ?></textarea>
                            </fieldset>

                        </div>
                    </li>



                    <li>
                        <input class="textlk-collapse" type="checkbox" id="<?php echo esc_attr($this->plugin_name . '-order_status_failed'); ?>" name="<?php echo esc_attr($this->plugin_name . '[order_status_failed]'); ?>" <?php checked($order_status_failed, 1); ?> />
                        <label for="<?php echo esc_attr($this->plugin_name . '-order_status_failed'); ?>">
                            <span class="toggle_btn"></span>
                            <span><?php esc_attr_e('On Order Failed', 'textlk-wp'); ?></span>
                        </label>
                        <div class="textlk-collapsable" id="order_status_failed">

                            <fieldset class="notify_template">
                                <legend>
                                    <span class="sms_tokens my-2 d-block"><span>[store_name]</span> |
                                        <span>[billing_first_name]</span> |
                                        <span>[order_id]</span> |
                                        <span>[order_status]</span> |  <span>[order_date_created]</span>
                                        <span>[order_currency]</span> | <span>[order_amount]</span>
                                    </span>
                                </legend>

                                <textarea id="<?php echo esc_attr($this->plugin_name . '-order_status_failed_sms'); ?>" name="<?php echo esc_attr($this->plugin_name . '[ORDER_STATUS_FAILED_SMS]'); ?>" rows="4" cols="85"><?php echo esc_html($order_status_failed_sms); ?></textarea>
                            </fieldset>

                        </div>
                    </li>

                    <li>
                        <input class="textlk-collapse" type="checkbox" id="<?php echo esc_attr($this->plugin_name . '-order_status_receipt_approval'); ?>" name="<?php echo esc_attr($this->plugin_name . '[order_status_receipt_approval]'); ?>" <?php checked($order_status_receipt_approval, 1); ?> />
                        <label for="<?php echo esc_attr($this->plugin_name . '-order_status_receipt_approval'); ?>">
                            <span class="toggle_btn"></span>
                            <span><?php esc_attr_e('On Order Receipt Approval', 'textlk-wp'); ?></span>
                        </label>
                        <div class="textlk-collapsable" id="order_status_receipt_approval">

                            <fieldset class="notify_template">
                                <legend>
                                    <span class="sms_tokens my-2 d-block"><span>[store_name]</span> |
                                        <span>[billing_first_name]</span> |
                                        <span>[order_id]</span> |
                                        <span>[order_status]</span> |  <span>[order_date_created]</span>
                                        <span>[order_currency]</span> | <span>[order_amount]</span>
                                    </span>
                                </legend>

                                <textarea id="<?php echo esc_attr($this->plugin_name . '-order_status_receipt_approval_sms'); ?>" name="<?php echo esc_attr($this->plugin_name . '[ORDER_STATUS_RECEIPT_APPROVAL_SMS]'); ?>" rows="4" cols="85"><?php echo esc_html($order_status_receipt_approval_sms); ?></textarea>
                            </fieldset>

                        </div>
                    </li>

                    <li>
                        <input class="textlk-collapse" type="checkbox" id="<?php echo esc_attr($this->plugin_name . '-order_status_receipt_upload'); ?>" name="<?php echo esc_attr($this->plugin_name . '[order_status_receipt_upload]'); ?>" <?php checked($order_status_receipt_upload, 1); ?> />
                        <label for="<?php echo esc_attr($this->plugin_name . '-order_status_receipt_upload'); ?>">
                            <span class="toggle_btn"></span>
                            <span><?php esc_attr_e('On Order Receipt Upload', 'textlk-wp'); ?></span>
                        </label>
                        <div class="textlk-collapsable" id="order_status_receipt_upload">

                            <fieldset class="notify_template">
                                <legend>
                                    <span class="sms_tokens my-2 d-block"><span>[store_name]</span> |
                                        <span>[billing_first_name]</span> |
                                        <span>[order_id]</span> |
                                        <span>[order_status]</span> |  <span>[order_date_created]</span>
                                        <span>[order_currency]</span> | <span>[order_amount]</span>
                                    </span>
                                </legend>

                                <textarea id="<?php echo esc_attr($this->plugin_name . '-order_status_receipt_upload_sms'); ?>" name="<?php echo esc_attr($this->plugin_name . '[ORDER_STATUS_RECEIPT_UPLOAD_SMS]'); ?>" rows="4" cols="85"><?php echo esc_html($order_status_receipt_upload_sms); ?></textarea>
                            </fieldset>

                        </div>
                    </li>

                    <li>
                        <input class="textlk-collapse" type="checkbox" id="<?php echo esc_attr($this->plugin_name . '-order_status_shipped'); ?>" name="<?php echo esc_attr($this->plugin_name . '[order_status_shipped]'); ?>" <?php checked($order_status_shipped, 1); ?> />
                        <label for="<?php echo esc_attr($this->plugin_name . '-order_status_shipped'); ?>">
                            <span class="toggle_btn"></span>
                            <span><?php esc_attr_e('On Order Shipped', 'textlk-wp'); ?></span>
                        </label>
                        <div class="textlk-collapsable" id="order_status_shipped">

                            <fieldset class="notify_template">
                                <legend>
                                    <span class="sms_tokens my-2 d-block"><span>[store_name]</span> |
                                        <span>[billing_first_name]</span> |
                                        <span>[order_id]</span> |
                                        <span>[order_status]</span> |  <span>[order_date_created]</span>
                                        <span>[order_currency]</span> | <span>[order_amount]</span>
                                    </span>
                                </legend>

                                <textarea id="<?php echo esc_attr($this->plugin_name . '-order_status_shipped_sms'); ?>" name="<?php echo esc_attr($this->plugin_name . '[ORDER_STATUS_SHIPPED_SMS]'); ?>" rows="4" cols="85"><?php echo esc_html($order_status_shipped_sms); ?></textarea>
                            </fieldset>

                        </div>
                    </li>

                    <li>
                        <input class="textlk-collapse" type="checkbox" id="<?php echo esc_attr($this->plugin_name . '-order_status_packed'); ?>" name="<?php echo esc_attr($this->plugin_name . '[order_status_packed]'); ?>" <?php checked($order_status_packed, 1); ?> />
                        <label for="<?php echo esc_attr($this->plugin_name . '-order_status_packed'); ?>">
                            <span class="toggle_btn"></span>
                            <span><?php esc_attr_e('On Order Packed', 'textlk-wp'); ?></span>
                        </label>
                        <div class="textlk-collapsable" id="order_status_packed">

                            <fieldset class="notify_template">
                                <legend>
                                    <span class="sms_tokens my-2 d-block"><span>[store_name]</span> |
                                        <span>[billing_first_name]</span> |
                                        <span>[order_id]</span> |
                                        <span>[order_status]</span> |  <span>[order_date_created]</span>
                                        <span>[order_currency]</span> | <span>[order_amount]</span>
                                    </span>
                                </legend>

                                <textarea id="<?php echo esc_attr($this->plugin_name . '-order_status_packed_sms'); ?>" name="<?php echo esc_attr($this->plugin_name . '[ORDER_STATUS_PACKED_SMS]'); ?>" rows="4" cols="85"><?php echo esc_html($order_status_packed_sms); ?></textarea>
                            </fieldset>

                        </div>
                    </li>

                    <!-- working end -->

                </ol>
            <?php } else { ?>
				<p>Install Woocommerce plugin to see Woocommerce related settings</p>
			<?php } ?>
  
            <?php submit_button(__('Save all changes', 'textlk-wp'), 'primary', 'submit', true); ?>
        </form>
    </div>
</div>