<?php

// If this file is called directly, abort.
if (!defined('WPINC')) {
    die;
}

class TextLK_SMS
{

    public $numbers;
    public $body;
    public $sender_id = '';
    private $textlk_sms_api_key;
    private $textlk_sms_api_url = 'https://app.text.lk/api/v3';

    public function __construct($textlk_sms_api_key)
    {
        $this->textlk_sms_api_key = $textlk_sms_api_key;
    }

    /**
     * @return mixed
     */
    public function Send()
    {
        $queryParams = [
            'api_token' => $this->textlk_sms_api_key,
            'recipient'        => $this->numbers,
            'message'       => $this->body,
            'sender_id' => $this->sender_id
        ];

        $response = $this->sendRequest($this->textlk_sms_api_url . '/sms/send', 'POST', $queryParams);

        $responseData = json_decode($response);
        
        if ($responseData && isset($responseData->status)) {
            if ($responseData->status === 'success') {
                $responseData->error = 0;
            } else {
                $responseData->error = 400;
            }
            $responseData->msg = $responseData->message;
        } else {
            // Handle case where response is not valid JSON or 'status' property is missing
            $responseData = new stdClass(); // Create a new object to avoid further errors
            $responseData->error = 500;
            $responseData->msg = 'Server Error';
        }
        
        return $responseData;
    }

    /**
     * @param $url
     * @param string $method
     * @param array $postfields
     * @return bool|string
     */
    private function sendRequest($url, $method = 'GET', $postfields = [])
    {

        $args = [
            'method'    => $method,
            'timeout'   => 45,
            'sslverify' => false,
            'headers'   => [
                'Content-Type' => 'application/json',
                'Accept'       => 'application/json',
                'Authorization'=> 'Bearer ' . $this->textlk_sms_api_key
            ]
        ];

        if ($method === 'POST') {
            $args['body'] = json_encode($postfields);
            
            // Uncomment the following lines if you want to use sandbox test request
        
            // sandbox
            /*
            $test_request = [
                "status" => "success",
                "message" => "Your message was successfully delivered",
                "data" => [
                    "uid" => "xxxxxx",
                    "to" => $postfields['recipient'],
                    "from" => $postfields['sender_id'],
                    "message" => $postfields['message'],
                    "customer_status" => "Delivered",
                    "cost" => "1.09",
                    "sms_count" => 1
                ]
            ];
            
            error_log($postfields['message']);
        
            return json_encode($test_request);
            */
            // sandbox
        }

        $request = wp_remote_request($url, $args);
        
        if (is_wp_error($request)) {
            return false;
        }

        return wp_remote_retrieve_body($request);
    }

    /**
     * @return mixed
     */
    public function getBalance()
    {
        $response = $this->sendRequest($this->textlk_sms_api_url . '/balance');

        $responseData = json_decode($response);

        if ($responseData->status == 'success') {
            $responseData->error = 0;
            $responseData->data->balance = $responseData->data->remaining_balance;
        } else {
            $responseData->error = 405;
        }

        return $responseData;
    }
}