<?php
/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://text.lk
 * @since             1.0.0
 * @package           TextLK
 *
 * @wordpress-plugin
 * Plugin Name:       Text.lk SMS Gateway
 * Plugin URI:        https://text.lk/plugins/wordpress
 * Description:       WP 2FA Login. SMS OTP Verification for Registration and Login. WooCommerce SMS Notification for your shop orders. Sri Lanka SMS Gateway for OTP Verification. 24/7 support.
 * Version:           1.1.6
 * Author:            Text.lk
 * Author URI:        https://text.lk/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       textlk-wp
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if (!defined('WPINC')) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define('TEXTLK_WP_VERSION', '1.1.6');

// plugin constants
try {
	$date = new DateTime("now", new DateTimeZone('Asia/Dhaka'));
} catch (Exception $e) {
	$date = new DateTime("now");
}
define("TEXTLK_WP_TIMESTAMP", $date->format('Y-m-d H:i:s'));
define('TEXTLK_WP_PATH', plugin_dir_path(__FILE__));

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-TextLK_Activator.php
 */
function textlk_activate()
{
	require_once plugin_dir_path(__FILE__) . 'includes/class-TextLK_Activator.php';
	TextLK_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-TextLK_Deactivator.php
 */
function textlk_deactivate()
{
	require_once plugin_dir_path(__FILE__) . 'includes/class-TextLK_Deactivator.php';
	TextLK_Deactivator::deactivate();
}

register_activation_hook(__FILE__, 'textlk_activate');
register_deactivation_hook(__FILE__, 'textlk_deactivate');

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path(__FILE__) . 'includes/class-TextLK.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function textlk_run()
{

	$plugin = new TextLK();
	$plugin->run();
}
textlk_run();
